<?php

namespace App\Http\Controllers;

use App\Classes\General\PublicConstants;
use App\Classes\Helpers\FileHelper;
use App\Models\BlogCategory;
use Illuminate\Http\Request;

class BlogCategoryController extends Controller
{
   
     public function index()
    {
        return view('BlogCategory.index',  ['BlogCategories'=>BlogCategory::all()]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('BlogCategory.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {        
        $request->validate(BlogCategory::$rules);      
        BlogCategory::create($request->all());
        return redirect(route('BlogCategory.index'))->with('Success','BlogCategory created successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(BlogCategory $BlogCategory)
    {
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(BlogCategory $BlogCategory)
    {
        return view('BlogCategory.edit', compact('BlogCategory'));        
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, BlogCategory $BlogCategory)
    {
        $request->validate(BlogCategory::$rules);        
        $BlogCategory->update($request->all());
        return redirect(route('BlogCategory.index'))->with('Success','BlogCategory updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(BlogCategory $BlogCategory)
    {
        $BlogCategory->delete();      
        return redirect(route('BlogCategory.index'))->with('Message', 'BlogCategory deleted successfully');
    }
}
