<?php

namespace App\Http\Controllers;

use App\Models\Order;
use Illuminate\Http\Request;

class GeneralController extends Controller
{
    public function dashboard()
    {
        $LastFiveMonthOrders=Order::where('created_at','>=',now()->subMonths(5))->get();
        $DashboardOrders=$LastFiveMonthOrders->groupBy(function($date) {
            return \Carbon\Carbon::parse($date->created_at)->format('Y-m'); // grouping by year and month
        })->map(function($row) {
            return $row->count();
        });
        // dd($DashboardOrders->toArray());
        return view('dashboard',compact('DashboardOrders'));
    }
    
}
