<?php

namespace App\Http\Controllers;

use App\Models\Banner;
use App\Models\Blog;
use App\Models\Product;
use App\Models\ProductCategory;

use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function home()
    {
        $Banners = Banner::all();
        $ProductCategoies=ProductCategory::where('id', '!=', 1)->get();
        $Products = $ProductCategoies->map(function ($category) {
            return $category->Products()->take(1)->get();
        });
        $Products=$Products->flatten();
        $Blogs= Blog::orderBy('created_at', 'desc')->take(3)->get();
        return view('welcome',compact('Banners','ProductCategoies','Products','Blogs'));
    }
    public function about()
    {
        return view('about');
    }
    public function products($ProductCategoryId=null)
    {
        $ProductCategory=ProductCategory::where('id','=',$ProductCategoryId??0)->first();
        if(!$ProductCategory)
        {
            $ProductCategories = ProductCategory::where('id', '!=',1)->get();
            $Products=Product::orderBy('updated_at','desc')->take(24)->get();            
        }
        else
        {
            $Products=$ProductCategory->Products;
            $ProductCategories=$ProductCategory->Children;
        }
        $MainCategories = ProductCategory::where('category_id', '=', 1)->get();
        return view('products',compact( 'ProductCategories','Products','MainCategories'));
    }
    public function contact()
    {
        return view('contact');
    }
    public function viewProduct($ProuductSlug) 
    {
        $Product=Product::where('slug', $ProuductSlug)->firstOrFail();
        if(!$Product)
        {
            abort(404);
        }        
        return view('view_product', compact('Product'));        
    }
}

