<?php

namespace App\Http\Controllers;

use App\Classes\General\PublicConstants;
use App\Classes\Helpers\FileHelper;
use App\Models\Product;
use App\Models\ProductImage;
use Illuminate\Http\Request;

class ProductController extends Controller
{
     /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $Products = Product::all();
        return view('Product.index', compact('Products'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('Product.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate(Product::rules());
        $request['user_id'] = auth()->id(); 
        if ($request->hasFile('imageFile')) {
            $request['image'] = FileHelper::FileUpload($request->file('imageFile'), PublicConstants::PRODUCT_IMAGE_PATH);
        }
        $product = Product::create($request->all());        
        if ($request->hasFile('ProductImages')) {
            $ImagePostfix=1;
            foreach ($request->file('ProductImages') as $image) {
                $ProductImage=new ProductImage();
                $ProductImage->product_id = $product->id;
                $ProductImage->image = FileHelper::FileUpload($image, PublicConstants::PRODUCT_IMAGE_PATH,$ImagePostfix++);
                $ProductImage->save();
            }
        }
        return redirect()->route('Product.index')->with('Success','Product created successfully   ');

    }

    /**
     * Display the specified resource.
     */
    public function show(Product $Product)
    {
        //return view('Product.show', compact('Product'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Product $Product)
    {
        return view('Product.edit', compact('Product'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Product $Product)
    {        
        $request->validate(Product::rules($Product->id));
        #region Not working
        $this->RemoveOldProductImage($Product,$request->OldProductImages);
        if ($request->hasFile('imageFile')) {
            $request['image'] = FileHelper::FileUploadWithReplace($request->file('imageFile'), PublicConstants::PRODUCT_IMAGE_PATH,$Product->image);
        }
        $Product->update($request->all());
         if ($request->hasFile('ProductImages')) {
            $ImagePostfix=1;
            foreach ($request->file('ProductImages') as $image) {
                $ProductImage=new ProductImage();
                $ProductImage->product_id = $Product->id;
                $ProductImage->image = FileHelper::FileUpload($image, PublicConstants::PRODUCT_IMAGE_PATH,$ImagePostfix++);
                $ProductImage->save();
            }
        }
        return redirect()->route('Product.index')->with('Success', 'Product updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Product $Product)
    {
        $this->RemoveOldProductImage($Product, []);
        $Product->delete();
        if($Product->image) {
            FileHelper::FileDelete(PublicConstants::PRODUCT_IMAGE_PATH, $Product->image);
        }
        return redirect()->route('Product.index')->with('Message', 'Product deleted successfully');
    }

    #region PrivateFunction
    private function RemoveOldProductImage($Product,$RequestedIds)
    {
        $CRequestedIds=collect($RequestedIds);
        $ProductImageIds=$Product->ProductImages()->pluck('id');
        $DeleteProductImageIds=$ProductImageIds->diff($CRequestedIds);
        foreach ($DeleteProductImageIds as $DeleteProductImageId) {
          $ProductImage = ProductImage::find($DeleteProductImageId);
            if ($ProductImage && $ProductImage->image) {
                FileHelper::FileDelete(PublicConstants::PRODUCT_IMAGE_PATH, $ProductImage->image);
            }
             $ProductImage->delete();
        }
    }
    #endregion
}
