<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BlogCategory extends Model
{
    protected $fillable = ['title', 'description'];

    public static $rules = [
        'title' => 'required|string|max:255',
        'description' => 'nullable|string|max:1000',
    ];
    public function blogs()
    {
        return $this->hasMany(Blog::class, 'category');
    }
}
