<?php

namespace App\Models;

use App\Classes\General\PublicConstants;
use App\Classes\Helpers\FileHelper;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;

class ProductImage extends Model
{
    protected $fillable = ['product_id', 'image'];

    public function Product()
    {
        return $this->belongsTo(Product::class);
    }
     protected function imageUrl(): Attribute
    {
        return Attribute::make(
            get: fn () =>FileHelper::FileLink(PublicConstants::PRODUCT_IMAGE_PATH, $this->image)
        );
    } 
}
