<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('blogs', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique();
            $table->text('user_id');
            $table->foreignId('category_id');
            $table->text('banner')->nullable();
            $table->text('excerpt')->nullable();
            $table->text('para1')->nullable();
            $table->text('para2')->nullable();
            $table->text('para3')->nullable();
            $table->text('para4')->nullable();
            $table->text('para5')->nullable();
            $table->timestamps();
            $table->foreign('category_id')->references('id')->on('blog_categories');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blogs');
    }
};
