@extends('layouts.app')
@section('title', 'Banner')
@section('content')
  <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Banner</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
    {{-- <div class="btn-group me-2"> <button type="button" class="btn btn-sm btn-outline-secondary">Share</button>
      <button type="button" class="btn btn-sm btn-outline-secondary">Export</button>
    </div>  --}}
    {{-- <button type="button"
      class="btn btn-sm btn-outline-secondary dropdown-toggle d-flex align-items-center gap-1">
      <svg class="bi" aria-hidden="true">
      <use xlink:href="#calendar3"></use>
      </svg>
      This week
    </button> --}}
    <a href="{{ route('Banner.index') }}" class="btn btn-outline-primary ml-2"><i class="bi bi-arrow-left-circle"></i> Back</a>
    </div>
  </div>
    <form action="{{ route('Banner.update',$Banner->id) }}" method="post" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="title" class="form-label">Title</label>
                    <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" value="{{$Banner->title }}" required name="title" onchange="title_onChange()">
                    @error('title') <span class="invalid-feedback">{{ $message }}</span> @enderror
                </div>               
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="link" class="form-label">Link</label>
                    <input type="url" class="form-control @error('link') is-invalid @enderror" id="link" name="link" value="{{$Banner->link}}">
                    @error('link') <span class="invalid-feedback">{{ $message }}</span> @enderror
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3 row">
                    <div class="col">                        
                        <label for="image" class="form-label">Image</label>
                        <input type="file" class="form-control @error('image') is-invalid @enderror" id="image" name="imageFile" accept="image/*"  onchange="viewImage(event)">                        
                        @error('image') <span class="invalid-feedback">{{ $message }}</span> @enderror
                    </div>
                    @if('Banner->image')                       
                        <div class="col" id="divImageViewer">
                            <button type="button" id="btnRemoveImage" onclick="RemoveImage()" class="btn btn-danger">X</button>
                            <img id="imagePreview" src="{{ $Banner->imageUrl }}" alt="Image Preview" class="img-fluid">
                        </div>
                    @endif
                </div>
            </div>
            <div class="col-md-6">                
                <label for="buttonText" class="form-label">Button</label>
                <input type="text" class="form-control @error('button') is-invalid @enderror" id="buttonText" name="button"  value="{{$Banner->button}}">
                @error('button') <span class="invalid-feedback">{{ $message }}</span> @enderror                               
            </div>
            <div class="col-md-6">                
                <label for="discountText" class="form-label">Discount Text</label>
                <input type="text" class="form-control @error('discount_text') is-invalid @enderror" id="discountText" name="discount_text" value="{{$Banner->discount_text}}">
                @error('discount_text') <span class="invalid-feedback">{{ $message }}</span> @enderror                               
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="description" class="form-label">Description</label>
                    <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{$Banner->description}}</textarea>
                    @error('description') <span class="invalid-feedback">{{ $message }}</span> @enderror
                </div>
            </div>
            <div class="col-md-12">
                <button type="submit" class="btn btn-primary"><i class="bi bi-floppy"></i> Update</button>
                <button type="reset" class="btn btn-secondary"><i class="bi bi-arrow-clockwise"></i> Reset</button>
                {{-- <a href="{{ route('Banner.index') }}" class="btn btn-secondary">Cancel</a> --}}
            </div>
        </div>
    </form>
    <script>
        function viewImage(event) {
            const imageViewer = document.getElementById('divImageViewer');
            const imagePreview = document.getElementById('imagePreview');
            imageViewer.style.display = 'block';
            imagePreview.src = URL.createObjectURL(event.target.files[0]);
        }
        function RemoveImage() {
            const imageViewer = document.getElementById('divImageViewer');
            const imagePreview = document.getElementById('imagePreview');
            const imageInput = document.getElementById('image');
            imageViewer.style.display = 'none';
            imagePreview.src = '#';
            imageInput.value = '';
        }
          function title_onChange() {
            const title = document.getElementById('title').value;
            const slug = document.getElementById('slug');
            slug.value = title.toLowerCase().replace(/ /g, '-').replace(/[^\w-]+/g, '');
        }
    </script>
@endsection