@extends('layouts.app')
@section('title', 'Banner')
@section('content')
  <x-flash />
  <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Banner</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
      <div class="btn-group me-2"> 
        <button type="button" class="btn btn-sm btn-outline-secondary">Share</button>
        <button type="button" class="btn btn-sm btn-outline-secondary">Export</button>
      </div>   
      <a href="{{ route('Banner.create') }}" class="btn btn-outline-primary ml-2"><i class="bi bi-plus-circle"></i> Add New</a>
    </div>
  </div>
  @if($Banners->count() > 0)
    <div id="carouselBanners" class="carousel slide">
      <div class="carousel-indicators">
        @foreach ($Banners as $Banner)
          <button type="button" data-bs-target="#carouselBanners" data-bs-slide-to="{{ $loop->iteration}}" @if($loop->index==0)class="active" aria-current="true" @endif aria-label="{{ $Banner->title }}"></button>
        @endforeach
      </div>
      <div class="carousel-inner">
        @foreach ($Banners as $Banner)
          <div class="carousel-item @if($loop->index == 0) active @endif">
            <img src="{{  $Banner->imageUrl}}" class="d-block w-100" alt="{{ $Banner->title }}">
            <div class="carousel-caption d-none d-md-block">
              <h5>{{ $Banner->title }}</h5>
              <p>{{ $Banner->description }}</p>
            </div>
          </div>
        @endforeach
      </div>
      <button class="carousel-control-prev" type="button" data-bs-target="#carouselBanners" data-bs-slide="prev">
        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
        <span class="visually-hidden">Previous</span>
      </button>
      <button class="carousel-control-next" type="button" data-bs-target="#carouselBanners" data-bs-slide="next">
        <span class="carousel-control-next-icon" aria-hidden="true"></span>
        <span class="visually-hidden">Next</span>
      </button>
    </div>
  @endif

  {{-- <h2>Banners</h2> --}}
  <div class="table-responsive">
    <table class="table table-striped">
      <thead>
        <tr>
        <th scope="col">#</th>
        <th scope="col">Title</th>
        <th scope="col">Link</th>
        <th colspan="2">Action</th>
        </tr>
      </thead>
      <tbody>
        @foreach ($Banners as $Banner)
          <tr>
            <td>{{ $loop->iteration }}</td>
            <td>{{ $Banner->title }}</td>
            <td>{{ $Banner->link }}</td>
            <td>
              <a class="btn btn-warning" href="{{ route('Banner.edit', $Banner->id) }}">
                <i class="bi bi-pencil-square"></i> Edit
              </a>
            </td>
            <td>
              <form action="{{ route('Banner.destroy', $Banner->id) }}" method="POST"
                onsubmit="return confirm('Are you sure you want to delete this banner?');">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger"><i class="bi bi-trash"></i> Delete</button>
              </form>
            </td>
          </tr>
        @endforeach
      </tbody>
    </table>
  </div>
@endsection