@use('App\Models\BlogCategory')
@extends('layouts.app')
@section('title', 'Blog')
@section('content')
  <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Blog</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
   
    <a href="{{ route('Blog.index') }}" class="btn btn-outline-primary ml-2"><i class="bi bi-arrow-left-circle"></i> Back</a>
    </div>
  </div>
    <form action="{{ route('Blog.store') }}" method="post" enctype="multipart/form-data">
        @csrf
        <div class="row">
            <div class="col-md-6">                
                <label for="title" class="form-label">Title</label>
                <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" name="title" value="{{ old('title') }}" required onchange="title_onChange()">
                @error('title') <span class="invalid-feedback">{{ $message }}</span> @enderror                               
            </div>
             <div class="col-md-6">                
                <label for="slug" class="form-label">Slug</label>
                <input type="text" class="form-control @error('slug') is-invalid @enderror" id="slug" name="slug" value="{{ old('slug') }}" required>
                @error('slug') <span class="invalid-feedback">{{ $message }}</span> @enderror                               
            </div>
            <div class="col-md-6">                
                <label for="Blog" class="form-label"><a href="{{ route('BlogCategory.index') }}">Category</a></label>
                <select id="Blog" name="category_id" class="form-control @error('category_id') is-invalid @enderror" >
                    @foreach (BlogCategory::get() as $DropdownItem)
                        <option value="{{ $DropdownItem->id }}">{{$DropdownItem->title}}</option>
                    @endforeach
                </select>                
                @error('category_id') <span class="invalid-feedback">{{ $message }}</span> @enderror                
            </div>
            <div class="col-md-6">    
                <div class="row">
                    <div class="col">                        
                        <label for="image" class="form-label">Image</label>
                        <input type="file" class="form-control @error('image') is-invalid @enderror" id="image" name="BannerFile" accept="image/*"  onchange="viewImage(event)">                        
                        @error('image') <span class="invalid-feedback">{{ $message }}</span> @enderror
                    </div>
                    <div class="col" id="divImageViewer" style="display: none;">
                        <button type="button" id="btnRemoveImage" onclick="RemoveImage()" class="btn btn-danger">X</button>
                        <img id="imagePreview" src="#" alt="Image Preview" class="img-fluid">
                    </div>
                </div>
            </div>  
            <div class="col-md-6">                
                <label for="excerpt" class="form-label">Excerpt</label>
                <input type="text" class="form-control @error('excerpt') is-invalid @enderror" id="excerpt" name="excerpt" value="{{ old('excerpt') }}" required>
                @error('excerpt') <span class="invalid-feedback">{{ $message }}</span> @enderror                               
            </div>  
            <div class="col-md-6">
                <label for="para1" class="form-label">Paragraph 1</label>
                <textarea class="form-control @error('para1') is-invalid @enderror" id="para1" name="para1" rows="3">{{ old('para1') }}</textarea>
                @error('para1') <span class="invalid-feedback">{{ $message }}</span> @enderror                
            </div>
            <div class="col-md-6">
                <label for="para2" class="form-label">Paragraph 2</label>
                <textarea class="form-control @error('para2') is-invalid @enderror" id="para2" name="para2" rows="3">{{ old('para2') }}</textarea>
                @error('para2') <span class="invalid-feedback">{{ $message }}</span> @enderror                
            </div>
            <div class="col-md-6">
                <label for="para3" class="form-label">Paragraph 3</label>
                <textarea class="form-control @error('para3') is-invalid @enderror" id="para3" name="para3" rows="3">{{ old('para3') }}</textarea>
                @error('para3') <span class="invalid-feedback">{{ $message }}</span> @enderror                
            </div>
            <div class="col-md-6">
                <label for="para4" class="form-label">Paragraph 4</label>
                <textarea class="form-control @error('para4') is-invalid @enderror" id="para4" name="para4" rows="3">{{ old('para4') }}</textarea>
                @error('para4') <span class="invalid-feedback">{{ $message }}</span> @enderror                
            </div>
            <div class="col-md-6">
                <label for="para5" class="form-label">Paragraph 5</label>
                <textarea class="form-control @error('para5') is-invalid @enderror" id="para5" name="para5" rows="3">{{ old('para5') }}</textarea>
                @error('para5') <span class="invalid-feedback">{{ $message }}</span> @enderror                
            </div>
            <div class="col-md-12 mt-2">
                <button type="submit" class="btn btn-primary"><i class="bi bi-floppy"></i> Save</button>
                <button type="reset" class="btn btn-secondary"><i class="bi bi-arrow-clockwise"></i> Reset</button>                
            </div>
        </div>
    </form>
    <script>
        function viewImage(event) {
            const imageViewer = document.getElementById('divImageViewer');
            const imagePreview = document.getElementById('imagePreview');
            imageViewer.style.display = 'block';
            imagePreview.src = URL.createObjectURL(event.target.files[0]);
        }
        function RemoveImage() {
            const imageViewer = document.getElementById('divImageViewer');
            const imagePreview = document.getElementById('imagePreview');
            const imageInput = document.getElementById('image');
            imageViewer.style.display = 'none';
            imagePreview.src = '#';
            imageInput.value = '';
        }
          function title_onChange() {
            const title = document.getElementById('title').value;
            const slug = document.getElementById('slug');
            slug.value = title.toLowerCase().replace(/ /g, '-').replace(/[^\w-]+/g, '');
        }
    </script>
@endsection