<?php
use App\Http\Controllers\AuthController;
use App\Http\Controllers\BannerController;
use App\Http\Controllers\BlogCategoryController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\GeneralController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ProductCategoryController;
use App\Http\Controllers\ProductController;
use Illuminate\Support\Facades\Route;

Route::get('/', [HomeController::class, 'home'])->name('home');
Route::get('/about', [HomeController::class, 'about'])->name('about');
Route::get('/products/{ProductCategoryId?}', [HomeController::class, 'products'])->name('products');
Route::get('view-product/{ProductSlug}', [HomeController::class, 'viewProduct'])->name('view_product');
Route::get('/contact', [HomeController::class, 'contact'])->name('contact');
Route::get('/cart/add/{ProductId}/{Quantity?}', [CartController::class, 'Add'])->name('cart.add');
Route::get('/cart', [CartController::class, 'get'])->name('cart.get');
Route::get('/cart/remove/{ProductId}', [CartController::class, 'Remove'])->name('cart.remove');
Route::get('/cart/checkout-a-product/{ProductId}/{Quantity?}', [CartController::class, 'CheckoutAProduct'])->name('cart.checkout_a_product');
Route::get('/cart/checkout', [CartController::class, 'Checkout'])->name('cart.checkout');

Route::middleware(['auth'])->group(function () {    
    Route::get('/dashboard',[GeneralController::class,'dashboard'])->name('dashboard');
    Route::resource('Banner', BannerController::class);
    Route::resource('BlogCategory', BlogCategoryController::class);
    Route::resource('Blog', BlogController::class);
    Route::resource('ProductCategory', ProductCategoryController::class);
    Route::resource('Product', ProductController::class);
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
});

Route::get('/login',[AuthController::class,'LoginView']);
Route::post('/login', [AuthController::class, 'login'])->name('login');
