<?php use \App\Models\ProductCategory; ?>
<!-- Include page layout -->



<!-- Start page content -->
<?php $__env->startSection('content'); ?>
    <!--Navigation section-->
    <div class="container">
        <nav class="biolife-nav">
            <ul>
                <li class="nav-item"><a href="index-2.html" class="permal-link">Home</a></li>
                <li class="nav-item"><a href="#" class="permal-link">Products</a></li>
                
            </ul>
        </nav>
    </div>

    <div class="page-contain category-page left-sidebar">
        <div class="container">
            <div class="row">
                <!-- Main content -->
                <div id="main-content" class="main-content col-lg-9 col-md-8 col-sm-12 col-xs-12">

                    <div class="block-item recently-products-cat md-margin-bottom-39">
                        <ul class="products-list biolife-carousel nav-center-02 nav-none-on-mobile"
                            data-slick='{"rows":1,"arrows":true,"dots":false,"infinite":false,"speed":400,"slidesMargin":0,"slidesToShow":5, "responsive":[{"breakpoint":1200, "settings":{ "slidesToShow": 3}},{"breakpoint":992, "settings":{ "slidesToShow": 3, "slidesMargin":30}},{"breakpoint":768, "settings":{ "slidesToShow": 2, "slidesMargin":10}}]}'>
                            <?php $__currentLoopData = $ProductCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ProductCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="product-item">
                                    <div class="contain-product layout-02">
                                        <div class="product-thumb">
                                            <a href="<?php echo e(route('products', $ProductCategory->id)); ?>" class="link-to-product">
                                                <img src="<?php echo e($ProductCategory->imageUrl); ?>" alt="dd"
                                                    style="height: 150px; object-fit: contain; width: 100%;"
                                                    class="product-thumnail">
                                            </a>
                                        </div>
                                        <div class="info">
                                            <b class="categories"><?php echo e($ProductCategory->Category?->title); ?></b>
                                            <h4 class="product-title"><a
                                                    href="<?php echo e(route('products', $ProductCategory->id)); ?>"
                                                    class="pr-name"><?php echo e($ProductCategory->title); ?></a>
                                            </h4>
                                            
                                        </div>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </ul>
                    </div>

                    <div class="product-category grid-style">

                        <div id="top-functions-area" class="top-functions-area">
                            
                            
                        </div>

                        <div class="row">
                            <ul class="products-list">
                                <?php $__currentLoopData = $Products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="product-item col-lg-4 col-md-4 col-sm-4 col-xs-6">
                                        <div class="contain-product layout-default">
                                            <div class="product-thumb">
                                                <a href="<?php echo e(route('view_product', $Product->slug)); ?>"
                                                    class="link-to-product">
                                                    <img src="<?php echo e($Product->imageUrl); ?>" alt="dd"
                                                        style="height: 200px; object-fit: contain; width: 100%;"
                                                        class="product-thumnail">
                                                </a>
                                            </div>
                                            <div class="info">
                                                <b class="categories"><?php echo e($Product->Category->title); ?></b>
                                                <h4 class="product-title"><a href="#"
                                                        class="pr-name"><?php echo e($Product->title); ?></a></h4>
                                                
                                                <div class="shipping-info">
                                                    <p class="shipping-day"><?php echo e($Product->sub_title); ?></p>
                                                    <p class="for-today"><?php echo e($Product->description); ?></p>
                                                </div>
                                                
                                                <p class="message"><?php echo e($Product->description); ?></p>
                                                <div class="buttons">
                                                    <a href="#"
                                                        onclick="AddToCart(<?php echo e($Product->id); ?>,1); return false;"
                                                        style="background: linear-gradient(135deg, #1e90ff, #3742fa);
              color: white;
              padding: 10px 20px;
              border-radius: 30px;
              text-decoration: none;
              font-size: 16px;
              font-weight: bold;
              text-transform: uppercase;
              box-shadow: 0 4px 8px rgba(0,0,0,0.2);
              display: flex;
              align-items: center;">
                                                        <i class="fa fa-cart-arrow-down" aria-hidden="true"
                                                            style="margin-right: 8px;"></i>
                                                        Add to Cart
                                                    </a>
                                                    
                                                </div>
                                                
                                                

                                                
                                                
                                            </div>
                                        </div>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </ul>
                        </div>

                        

                    </div>

                </div>
                <!-- Sidebar -->
                <aside id="sidebar" class="sidebar col-lg-3 col-md-4 col-sm-12 col-xs-12">
                    <div class="biolife-mobile-panels">
                        <span class="biolife-current-panel-title">Sidebar</span>
                        <a class="biolife-close-btn" href="#" data-object="open-mobile-filter">&times;</a>
                    </div>
                    <div class="sidebar-contain">
                        <div class="widget biolife-filter">
                            <h4 class="wgt-title">Main Categories</h4>
                            <div class="wgt-content">
                                <ul class="cat-list">
                                    <li class="cat-list-item"><a href="<?php echo e(route('products')); ?>" class="cat-link">All</a>
                                    </li>
                                    <?php $__currentLoopData = $MainCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $MainCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="cat-list-item"><a href="<?php echo e(route('products', $MainCategory->id)); ?>"
                                                class="cat-link"><?php echo e($MainCategory->title); ?></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>

                        

                        

                        

                        

                        

                        

                        

                        <div class="widget biolife-filter">
                            <h4 class="wgt-title">Product Tags</h4>
                            <div class="wgt-content">
                                <ul class="tag-cloud">
                                    <?php $__currentLoopData = ProductCategory::RootCategories(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="tag-item"><a href="<?php echo e(route('products', $Category->slug)); ?>"
                                                class="tag-link"><?php echo e($Category->title); ?></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>

                </aside>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<!-- End page content -->

<?php echo $__env->make('layouts.front', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/redhatsafetyae/public_html/demo/resources/views/products.blade.php ENDPATH**/ ?>