<?php use \App\Models\ProductCategory; ?>

<?php $__env->startSection('title', 'Product'); ?>
<?php $__env->startSection('content'); ?>
  <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Product</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
    
    
    <a href="<?php echo e(route('Product.index')); ?>" class="btn btn-outline-primary ml-2"><i class="bi bi-arrow-left-circle"></i> Back</a>
    </div>
  </div>
    <form action="<?php echo e(route('Product.update',$Product->id)); ?>" method="post" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="row">
            <div class="col-md-6">                
            <label for="title" class="form-label">Title</label>
            <input type="text" class="form-control <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="title" name="title" value="<?php echo e($Product->title); ?>" required>
            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="invalid-feedback"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>                               
            </div>
            <div class="col-md-6">                
            <label for="Product" class="form-label"><a href="<?php echo e(route('ProductCategory.index')); ?>">Category</a></label>
            <select id="Product" name="category_id" class="form-control <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" >
                <?php $__currentLoopData = ProductCategory::where('id','!=',1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $DropdownItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($DropdownItem->id); ?>" <?php echo e($Product->category_id == $DropdownItem->id ? 'selected' : ''); ?>><?php echo e($DropdownItem->title); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>                
            <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="invalid-feedback"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>                
            </div>
            <div class="col-md-6">                
            <label for="slug" class="form-label">Slug</label>
            <input type="text" class="form-control <?php $__errorArgs = ['slug'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="slug" name="slug" value="<?php echo e($Product->slug); ?>" required>
            <?php $__errorArgs = ['slug'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="invalid-feedback"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>                               
            </div>
            <div class="col-md-6">                
            <label for="sub_title" class="form-label">Subtitle</label>
            <input type="text" class="form-control <?php $__errorArgs = ['sub_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="sub_title" name="sub_title" value="<?php echo e($Product->sub_title); ?>" >
            <?php $__errorArgs = ['sub_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="invalid-feedback"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>                               
            </div>
            <div class="col-md-6">                
            <label for="price" class="form-label">Price</label>
            <input type="text" class="form-control <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="meta_title" name="price" value="<?php echo e($Product->price); ?>" >
            <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="invalid-feedback"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>                               
            </div>
            <div class="col-md-6">                
            <label for="original_price" class="form-label">Original Price</label>
            <input type="text" class="form-control <?php $__errorArgs = ['original_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="original_price" name="original_price" value="<?php echo e($Product->original_price); ?>" >
            <?php $__errorArgs = ['original_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="invalid-feedback"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>                               
            </div>
            <div class="col-md-6">                
            <label for="rating" class="form-label">Rating</label>
            <input type="text" class="form-control <?php $__errorArgs = ['rating'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="rating" name="rating" value="<?php echo e($Product->rating); ?>" required>
            <?php $__errorArgs = ['rating'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="invalid-feedback"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>                               
            </div>
            <div class="col-md-6">
            <label for="description" class="form-label">Description</label>
            <textarea class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="description" name="description" rows="3"><?php echo e($Product->description); ?></textarea>
            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="invalid-feedback"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>                
            </div>
            <div class="col-md-6">
            <label for="about" class="form-label">About</label>
            <textarea class="form-control <?php $__errorArgs = ['about'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="about" name="about" rows="3"><?php echo e($Product->about); ?></textarea>
            <?php $__errorArgs = ['about'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="invalid-feedback"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>                
            </div>
            <div class="col-md-6">
            <label for="quantity" class="form-label">Quantity</label>
            <input type="number" class="form-control <?php $__errorArgs = ['quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="quantity" name="quantity" value="<?php echo e($Product->quantity); ?>"  min="0">
            <?php $__errorArgs = ['quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="invalid-feedback"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>           
            <div class="col-md-6">    
            <div class="row">
                <div class="col">                        
                <label for="image" class="form-label">Image</label>
                <input type="file" class="form-control <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="image" name="imageFile" accept="image/*" onchange="viewImage(event,0)">                        
                <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="invalid-feedback"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="col" id="divImageViewer0">
                <button type="button" id="btnRemoveImage0" onclick="RemoveImage(0)" class="btn btn-danger">X</button>
                <img id="imagePreview0" src="<?php echo e($Product->imageUrl); ?>" alt="Image Preview" class="img-fluid">
                </div>
            </div>
            </div>             
        </div>
        <hr class="my-4">
        <h4>Other Images</h4>
        <div class="row" id="divOtherImages">
          <?php $__currentLoopData = $Product->ProductImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $I => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
           <?php
             $index = $I + 1;
           ?>
             
            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="input-group">
                        <input type="file" class="form-control" name="ProductImages[]" accept="image/*" onchange="viewImage(event, <?php echo e($index); ?>)">
                        <button type="button" class="btn btn-danger" onclick="RemoveImage(<?php echo e($index); ?>)">Remove</button>
                    </div>
                </div>
                <div class="col-md-6" id="divImageViewer<?php echo e($index); ?>" style="<?php echo e($image->image ? '' : 'display:none;'); ?>">
                    <input type="hidden" name="OldProductImages[]" value="<?php echo e($image->id); ?>" id="htnProductImage<?php echo e($index); ?>">
                    <img id="imagePreview<?php echo e($index); ?>" src="<?php echo e($image->imageUrl); ?>" alt="Image Preview" class="img-fluid mt-2" style="height: 100px;">
                </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="row border border-secondary p-2">
            <div class="col">
                <button type="button" class="btn btn-info" onclick="bntAddImage_Click();"><i class="bi bi-plus"></i> <i
                        class="bi bi-image"></i> Add Image</button>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 mt-2">
                <button type="submit" class="btn btn-primary"><i class="bi bi-floppy"></i> Save</button>
                <button type="reset" class="btn btn-secondary"><i class="bi bi-arrow-clockwise"></i> Reset</button>
            </div>
        </div>
    </form>
     <script>
        function viewImage(event, index) {
            index = index.toString();
            const imageViewer = document.getElementById('divImageViewer' + index);
            const imagePreview = document.getElementById('imagePreview' + index);
            imageViewer.style.display = 'block';
            imagePreview.src = URL.createObjectURL(event.target.files[0]);
        }
        function RemoveImage(index) {
            const imageViewer = document.getElementById('divImageViewer' + index);
            const imagePreview = document.getElementById('imagePreview' + index);
            const imageInput = document.getElementById('image' + index);
            if(index!=0)
                document.getElementById('htnProductImage' + index).remove();
            imageViewer.style.display = 'none';
            imagePreview.src = '#';
            imageInput.value = '';
        }
        //Auto Slug
        function title_onChange() {
            const title = document.getElementById('title').value;
            const slug = document.getElementById('slug');
            slug.value = title.toLowerCase().replace(/ /g, '-').replace(/[^\w-]+/g, '');
        }
        var GlobalImageIndex = 1;
        function bntAddImage_Click() {
            const divOtherImages = document.getElementById('divOtherImages');

            // Create wrapper div for the new image input
            const newImageDiv = document.createElement('div');
            newImageDiv.className = 'row mb-3'; // Adds spacing between entries

            // Create input group column
            const inputCol = document.createElement('div');
            inputCol.className = 'col-md-6';

            const inputGroup = document.createElement('div');
            inputGroup.className = 'input-group';

            const fileInput = document.createElement('input');
            fileInput.type = 'file';
            fileInput.className = 'form-control';
            fileInput.name = 'other_images';
            fileInput.accept = 'image/*';
            fileInput.name='ProductImages[]';
            fileInput.setAttribute('onchange', `viewImage(event, ${GlobalImageIndex})`);

            const removeButton = document.createElement('button');
            removeButton.type = 'button';
            removeButton.className = 'btn btn-danger';
            removeButton.textContent = 'Remove';
            removeButton.onclick = function () {
                newImageDiv.remove();
            };

            inputGroup.appendChild(fileInput);
            inputGroup.appendChild(removeButton);
            inputCol.appendChild(inputGroup);

            // Create image preview column
            const previewCol = document.createElement('div');
            previewCol.className = 'col-md-6';
            previewCol.id = `divImageViewer${GlobalImageIndex}`;
            previewCol.style.display = 'none';

            const previewImg = document.createElement('img');
            previewImg.id = `imagePreview${GlobalImageIndex}`;
            previewImg.src = '#';
            previewImg.alt = 'Image Preview';
            previewImg.className = 'img-fluid mt-2';
            previewImg.style.height = '100px';
            // previewImg.style.display = 'none';

            previewCol.appendChild(previewImg);

            // Append both columns to the wrapper
            newImageDiv.appendChild(inputCol);
            newImageDiv.appendChild(previewCol);

            // Append to the main container
            divOtherImages.appendChild(newImageDiv);

            GlobalImageIndex++;
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Irfan\Desktop\ErpLite\resources\views/Product/edit.blade.php ENDPATH**/ ?>