<?php use \App\Http\Controllers\CartController; ?>
<div class="minicart-contain">
    <a href="javascript:void(0)" class="link-to">
        <span class="icon-qty-combine">
            <i class="icon-cart-mini biolife-icon"></i>
            <span class="qty"><?php echo e(count(CartController::Get())); ?></span>
        </span>
        <span class="title">My Cart </span>
        
    </a>
    <div class="cart-content">
        <div class="cart-inner">
            <div>
                <ul class="products">
                    <?php $__currentLoopData = CartController::Get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ProductId=>$CartItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <div class="minicart-item">
                                <div class="thumb">
                                    <a href="#"><img src="<?php echo e($CartItem['product']?->ImageUrl); ?>" width="90" height="90"
                                            alt="National Fresh"></a>
                                </div>
                                <div class="left-info">
                                    <div class="product-title"><a href="#" class="product-name"><?php echo e($CartItem['product']?->title); ?></a></div>
                                    
                                    <div class="qty">
                                        <label for="cart[id<?php echo e($ProductId); ?>][qty]">Qty:</label>
                                        <input type="number" class="input-qty" style="background: #555" name="cart[id<?php echo e($ProductId); ?>][qty]"
                                            id="cart[id<?php echo e($ProductId); ?>][qty]" value="<?php echo e($CartItem["quantity"]); ?>" disabled
                                             onfocus="BeginChangeCart(this, <?php echo e($ProductId); ?>)"
                                             onchange="ChangedCart(this, <?php echo e($ProductId); ?>);">
                                    </div>
                                </div>
                                <div class="action">
                                    <a href="#" class="edit" onclick="UpdateCart(<?php echo e($ProductId); ?>); return false;"><i class="fa fa-pencil" aria-hidden="true"></i></a>
                                    <a href="#" onclick="RemoveFromCart(<?php echo e($ProductId); ?>); return false;" class="remove"><i class="fa fa-trash-o" aria-hidden="true"></i></a>
                                </div>
                            </div>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>                                            
            <p class="btn-control">
                
                <a href="<?php echo e(route('cart.checkout')); ?>" class="btn">checkout</a>
            </p>
        </div>
    </div>
</div>
<script src="<?php echo e(asset('assets/js/cart.js')); ?>"></script><?php /**PATH /home/redhatsafetyae/public_html/demo/resources/views/cart/index.blade.php ENDPATH**/ ?>